

/******************************************************************************
 
 MD2Loader.cpp

 Copyright  2006, Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/
 
/******************************************************************************/
#define PLATFORM_WIN32 1 
 
#include <windows.h>
#include "rt_def.h" // for defn. of types
#include "rt_actor.h" 
#include "rt_stat.h"  
#include "MD2Loader.h"
//#include "..\3DS_Loader\3DS.h"
//#include "..\3DS_Loader\3DSstruct.h"

#include "..\3DS_Loader\Model_3DS.h"


#include "rt_door.h" 


#include <sdl.h>
#include <math.h>
#include <gl\gl.h>
#include <gl\glu.h>

// ----------- DEFINES --------------------------------------------------------
#define MAXMODELS 2048


// ----------- GLOBALS --------------------------------------------------------
int MD2ObjIndex[MAXMODELS];//max 2048 models a one time
MD2Model MD2ObjList[MAXMODELS];

extern int DrawGLScene(int objnb,char *modelname, float x,float y,float z,float xoff,float yoff,float zoff);	
extern void Import3DAssimpModel(int objnb,char *Modelname, char *Modelpath);
/*
extern void draw3D (int  md2scale,int md2zoff,int tcnt,double x,double y,double z);
extern int DrawGLScene(char *modelname,float x,float y,float z,float xoff,float yoff,float zoff);
extern bool Import3DFromFile(char*Modelname, char* Modelpath);


Model_3DS m;
*/
//extern int load_3ds(FILE *fp);
//extern mesh_object *head, *tail;
//extern mat_list *mathead, *mattail;
//extern map_list *maphead, *maptail;






// ----------- EXTERN PROTOTYPES ----------------------------------------------
extern "C"{
void LoadT3Dmodel();

	
	extern int loadasset (const char* path);
	extern void displayassimp(float x,float y,float z);


	extern byte* HEAP_getheapmem(int size);
	extern BOOL  HEAP_freemem(LPVOID lpMem);
	void InitMD2 ();
	void ResetMD2index ();
	int  LoadMD2Model(char *fname, int md2state, char *extrainfo);
	void MD2Draw(int objnb, int md2state,int  md2scale,int md2zoff,int tcnt,double x,double y,double z,double xtile,double ytile,double ztile);
	extern int LoadExtImgToTexture (const char *path_buffer, int repeat, int mipmaps, int *w, int *h);

	extern int LoadModelTexture (const char *fname, int repeat, int mipmaps, int *w, int *h);

	extern int GetRailingDir (int tilex, int tiley, int which, int flags);//bna added 154 
	extern void STM ();
	extern void WriteDebug (char *error, int i,...);
	extern int GetTicCount();
	int GetActorDir (dirtype dir);
	int GetActorFineTurnAngle (objtype *obj);
	int GetModelInfo (objtype *obj, char *name);
	int MD2refresh (unsigned int id ,char *name,double x,double y,double z,double angle );
	extern int HI_ReadBmpEx (LPSTR file, byte * dest, int *iWidth, int *iHeight);
	extern char* GLPath;
}








int		ReadPolygonTextIn(FILE*f, char *buf);
int		T3D_Tex=0;
UCHAR	*pixels=0;
GLvoid	CalculateVectorNormal(GLfloat fVert1[], GLfloat fVert2[],

                             GLfloat fVert3[], GLfloat *fNormalX,
                             GLfloat *fNormalY, GLfloat *fNormalZ);

typedef struct {
    int numofvertex;
 	MD2Vector vertex[128];
} polygon;

polygon T3Dpolygons[64];
int GetUnrealT3Dlevel(char *fname);

/********************************************************************/
/*																	*/
/* Function name : MD2Model											*/
/* Description   :													*/
/*																	*/
/********************************************************************/
MD2Model::MD2Model()
{
	NumVertices = 0;		// Vertices
	NumPolygons = 0;		// Polygons (triangles)
	NumFrames = 0;			// Frames
	NumTexCoords = 0;		// Texture coordinates
	NumStates = 0;
	FrameSize = 0;			// Framesize?
	ModelTex = 0;			// Skin/texture
	mCurrentFrame = 0;		// Current animation frame
	mNextFrame = 0;			// Next animation frame
	mInterpolation = 0;		// Interpolation counter
	mCurrentStateIndex = 0;	// Current animation state
	mNextStateIndex = 0;    // Next animation state
	mTick = 0;
	PolygonsIndex = 0;		// Polygons (triangles) indices
	TextureCoords = 0;		// Texture coordinate indices
	VertexList = 0;			// Vertices list
	LastState = 0;

	Xrot = 90;
	Yrot = 0;
	Zrot = 0;
	Scale = 1;
}


/********************************************************************/
/*																	*/
/* Function name : ~MD2Model()										*/
/* Description   :													*/
/*																	*/
/********************************************************************/
MD2Model::~MD2Model()
{
	if (PolygonsIndex != NULL) 
		free(PolygonsIndex);
	if (VertexList != NULL) 
		free(VertexList);
	if (TextureCoords != NULL) 
		free(TextureCoords);



}



/********************************************************************/
/*																	*/
/* Function name : Load()											*/
/* Description   : Load MD2 model and texture						*/
/*																	*/
/********************************************************************/
bool MD2Model::Load(char *modelFile, char *skinFile, int md2state)
{
	FILE *hfile;
	int filelen;
	MD2ModelHeader header;
	MD2Frame frame;
	MD2Vector*vectors;// 
	char LastAniName[18];
	char AniName[18];
	char fntmp[256];	
	int  i,h,w,j,l,AniNb,framecnt = 0;
	char *ptr;  int weds = 0;      
    
  //  char tmp[256];
  //  sprintf(tmp,"Loading MD2 model '%s'",modelFile);
  //  WriteDebug(tmp,0);   

	NumStates = -1;
	memset(AniName,0,sizeof(AniName));
	memset(LastAniName,0,sizeof(LastAniName));
	memset(g_animatestate,0,sizeof(g_animatestate));

	hfile = fopen(modelFile, "rb");
	if (hfile == NULL){
		sprintf(fntmp,"%s\\%s",GLPath,modelFile);//try default gl folder		
		hfile = fopen(fntmp, "rb");
		if (hfile == NULL){
            char tmp8[256];
            sprintf(tmp8,"MD2 model '%s' could not be loaded",modelFile);
            WriteDebug(tmp8,0);     
    		return false;
        }
	}


	weds = fseek(hfile, 0, SEEK_END);
	filelen = ftell(hfile);

	ReadHeader(hfile, header);

	NumVertices = header.NumVertices;
	NumFrames = header.NumFrames;
	NumTexCoords = header.NumTexCoords;
	NumPolygons = header.NumPolygons;
	FrameSize = header.framesize;


//	VertexList = rnew MD2Vector [NumVertices * NumFrames];
	VertexList = (MD2Vector *)malloc ((NumVertices * NumFrames)*sizeof(MD2Vector));

	frame.fp = NULL;
	for (j = 0; j < NumFrames; j++) {
	 
		int weds = fseek(hfile, header.offsetFrames + FrameSize * j, SEEK_SET);
		 
		frame.scale[0] = ReadFloat(hfile);
		frame.scale[1] = ReadFloat(hfile);
		frame.scale[2] = ReadFloat(hfile);
		frame.translate[0] = ReadFloat(hfile);
		frame.translate[1] = ReadFloat(hfile);
		frame.translate[2] = ReadFloat(hfile);

		fread(&frame.name, sizeof(char), 16, hfile);
		//find animation name and sequence
		//remove first nb  
		lstrcpy(AniName,frame.name);
		l = lstrlen(AniName);
		if (l > 0){
			ptr = AniName;
			//find the number in the end of the name
			for (i = 0; i < l; i++){
				if ((*ptr >= '0') && (*ptr <= '9')){
					AniNb = atol(ptr);//Do we need this?
					*ptr = 0;
					break;
				}
				ptr++;
			}
/*			do {
				ptr--;
			}while ( (ptr > AniName) && (*ptr >= '0') && (*ptr <= '9') );
			ptr++;
			AniNb = atol(ptr);//Do we need this?
			*ptr = 0;*/

			//compare the names 
			if (lstrcmpi(AniName,LastAniName)==0){
				//must be a follow frame or last in animation
				if ((NumStates >= 0) && (NumStates <= 21))//max 21 animations
					g_animatestate[NumStates].end = j;
			}else{
				//must be a new frame
				NumStates++;
				lstrcpy(g_animatestate[NumStates].statename,AniName);
				g_animatestate[NumStates].start = j;
				g_animatestate[NumStates].fps = 0;
			}
			lstrcpy(LastAniName, AniName);	
		}
		if (frame.fp != NULL) free(frame.fp);
		frame.fp = (MD2FramePoint *) calloc(NumVertices, sizeof(MD2FramePoint));
		fread(frame.fp, sizeof(MD2FramePoint), NumVertices, hfile);
		 

		vectors = (MD2Vector*) &VertexList[NumVertices * j];
		for (i = 0; i < NumVertices; i++) {		  
			VertexList[NumVertices * j + i].point[0] = frame.scale[0] * frame.fp[i].v[0] + frame.translate[0];
			VertexList[NumVertices * j + i].point[1] = frame.scale[1] * frame.fp[i].v[1] + frame.translate[1];
			VertexList[NumVertices * j + i].point[2] = frame.scale[2] * frame.fp[i].v[2] + frame.translate[2];
		}

	}
	//must be a last frame in animation
	//kObjectStates[--NumStates].End = j;
	g_animatestate[NumStates++].end = j;

	//load the texture
    ModelTex = LoadExtImgToTexture(skinFile,1,20,&w,&h);  
	if(ModelTex == -1){
        char tmp9[256];
        sprintf(tmp9,"MD2 skintex '%s' could not be loaded",skinFile);
        WriteDebug(tmp9,0);   
		return false;
    }
	//TextureCoords=rnew MD2TextureCoord[N umTexCoords];
	TextureCoords = (MD2TextureCoord *)malloc (NumTexCoords*sizeof(MD2TextureCoord));


	weds = fseek(hfile,header.offsetST,SEEK_SET);
	for (i = 0; i < NumTexCoords; i++) {
		TextureCoords[i].s = (float)ReadShort(hfile) / (float)w;
		TextureCoords[i].t = (float)ReadShort(hfile) / (float)h;
	}


	PolygonsIndex = (MD2Mesh *)malloc ((NumFrames * NumPolygons)*sizeof(MD2Mesh));
//	PolygonsIndex = rnew MD2Mesh [NumFrames * NumPolygons];

	weds = fseek(hfile, header.offsetPolygons, SEEK_SET);
	for (i = 0; i < NumPolygons; i++) {
		PolygonsIndex[i].meshindex[0] = ReadShort(hfile);
		PolygonsIndex[i].meshindex[1] = ReadShort(hfile);
		PolygonsIndex[i].meshindex[2] = ReadShort(hfile);
		PolygonsIndex[i].toiindex[0] = ReadShort(hfile);
		PolygonsIndex[i].toiindex[1] = ReadShort(hfile);
		PolygonsIndex[i].toiindex[2] = ReadShort(hfile);
	}

	fclose(hfile);

    SetState(md2state);

	return true;
}



/********************************************************************/
/*																	*/
/* Function name : DrawMD2											*/
/* Description   : Draws MD2 model									*/
/*																	*/
/********************************************************************/
void MD2Model::DrawMD2(int  md2scale,int md2zoff,int tcnt)
{
	MD2Vector *vList;      // Current frame vertices
	MD2Vector *nextVList;  // Next frame vertices
	MD2Vector vertex[3]; 
	float x1, y1, z1;      // Current frame point values
	float x2, y2, z2;	   // Next frame point values
	int i;      

	//update frame animation seqence
	UpdateAnimation(tcnt);
 
	vList = &VertexList[NumVertices*mCurrentFrame];
	if (vList == 0)
		return;

	nextVList = &VertexList[NumVertices*mNextFrame];
//LoadT3Dmodel();
	glEnd();
//return;
	glBindTexture(GL_TEXTURE_2D, ModelTex);

	//draw the Model
	glBegin(GL_TRIANGLES);



	for (i = 0; i < NumPolygons; i++) {	 
		//get 1 points of each frame
		x1 = vList[PolygonsIndex[i].meshindex[0]].point[0];
		y1 = vList[PolygonsIndex[i].meshindex[0]].point[1];
		z1 = vList[PolygonsIndex[i].meshindex[0]].point[2];
		x2 = nextVList[PolygonsIndex[i].meshindex[0]].point[0];
		y2 = nextVList[PolygonsIndex[i].meshindex[0]].point[1];
		z2 = nextVList[PolygonsIndex[i].meshindex[0]].point[2];
		 
		//store 1 interpolated vertex of polygon
		vertex[0].point[0] = md2scale*(x1 + mInterpolation * (x2 - x1));
		vertex[0].point[1] = md2scale*(y1 + mInterpolation * (y2 - y1));
		vertex[0].point[2] = md2scale*(z1 + mInterpolation * (z2 - z1));
		 
		//get 2 points of each frame
		x1 = vList[PolygonsIndex[i].meshindex[2]].point[0];
		y1 = vList[PolygonsIndex[i].meshindex[2]].point[1];
		z1 = vList[PolygonsIndex[i].meshindex[2]].point[2];
		x2 = nextVList[PolygonsIndex[i].meshindex[2]].point[0];
		y2 = nextVList[PolygonsIndex[i].meshindex[2]].point[1];
		z2 = nextVList[PolygonsIndex[i].meshindex[2]].point[2];
		 
		//store 2 interpolated vertex of polygon
		vertex[2].point[0] = md2scale*(x1 + mInterpolation * (x2 - x1));
		vertex[2].point[1] = md2scale*(y1 + mInterpolation * (y2 - y1));
		vertex[2].point[2] = md2scale*(z1 + mInterpolation * (z2 - z1));   
		 
		//retrive 3 points of each frame
		x1 = vList[PolygonsIndex[i].meshindex[1]].point[0];
		y1 = vList[PolygonsIndex[i].meshindex[1]].point[1];
		z1 = vList[PolygonsIndex[i].meshindex[1]].point[2];
		x2 = nextVList[PolygonsIndex[i].meshindex[1]].point[0];
		y2 = nextVList[PolygonsIndex[i].meshindex[1]].point[1];
		z2 = nextVList[PolygonsIndex[i].meshindex[1]].point[2];
		 
		//store 3 interpolated vertex of polygon
		vertex[1].point[0] = md2scale*(x1 + mInterpolation * (x2 - x1));
		vertex[1].point[1] = md2scale*(y1 + mInterpolation * (y2 - y1));
		vertex[1].point[2] = md2scale*(z1 + mInterpolation * (z2 - z1));
	 
		//find the normal of the polygon
		CalcNormal(vertex[0].point, vertex[2].point, vertex[1].point);

		//render textured polygon
		glTexCoord2f(TextureCoords[PolygonsIndex[i].toiindex[0]].s, TextureCoords[PolygonsIndex[i].toiindex[0]].t);
		glVertex3fv(vertex[0].point);
		 
		glTexCoord2f(TextureCoords[PolygonsIndex[i].toiindex[1]].s, TextureCoords[PolygonsIndex[i].toiindex[1]].t);
		glVertex3fv(vertex[1].point);
		 
		glTexCoord2f(TextureCoords[PolygonsIndex[i].toiindex[2]].s, TextureCoords[PolygonsIndex[i].toiindex[2]].t);
		glVertex3fv(vertex[2].point);
	}

	glEnd();

}




/********************************************************************/
/*																	*/
/* Function name : ReadHeader										*/
/* Description   : Reads MD2 model Header							*/
/*																	*/
/********************************************************************/
void MD2Model::ReadHeader(FILE *hfile, MD2ModelHeader & header)
{
	int weds = fseek(hfile, 0, SEEK_SET);

	header.ident = ReadInt(hfile);
	header.version = ReadInt(hfile);
	header.skinwidth = ReadInt(hfile);
	header.skinheight = ReadInt(hfile);
	header.framesize = ReadInt(hfile);
	header.NumSkins = ReadInt(hfile);
	header.NumVertices = ReadInt(hfile);
	header.NumTexCoords = ReadInt(hfile);
	header.NumPolygons = ReadInt(hfile);
	header.NumGLCmds = ReadInt(hfile);
	header.NumFrames = ReadInt(hfile);
	header.offsetSkins = ReadInt(hfile);
	header.offsetST = ReadInt(hfile);
	header.offsetPolygons = ReadInt(hfile);
	header.offsetFrames = ReadInt(hfile);
	header.offsetGLCmds = ReadInt(hfile);
	header.offsetEndOfFile = ReadInt(hfile);

}


/********************************************************************/
/*																	*/
/* Function name : CalcNormal										*/
/* Description   :  calculates the normal to points					*/
/*																	*/
/********************************************************************/
void MD2Model::CalcNormal( float *p1, float *p2, float *p3 )
{
	float a[3], b[3], res[3];
	float len;

    a[0] = p1[0] - p2[0];
	a[1] = p1[1] - p2[1];
	a[2] = p1[2] - p2[2];
	b[0] = p1[0] - p3[0];
	b[1] = p1[1] - p3[1];
	b[2] = p1[2] - p3[2];
	res[0] = a[1] * b[2] - b[1] * a[2];
	res[1] = b[0] * a[2] - a[0] * b[2];
	res[2] = a[0] * b[1] - b[0] * a[1];
	// find len of the normal
	len = (float)sqrt(res[0]*res[0] + res[1]*res[1] + res[2]*res[2]);
	// normalize 
	glNormal3f(res[0]/len, res[1]/len, res[2]/len);

}



/********************************************************************/
/*																	*/
/* Function name : SetState											*/
/* Description   : Sets the animation state							*/
/*																	*/
/********************************************************************/
void MD2Model::SetState(int iState)
{
	if ((iState > NumStates) || (iState < 0))
		iState = 0;
//	if (iState == mCurrentStateIndex)
//		return;	
	mCurrentStateIndex = mNextStateIndex = iState;
	mCurrentState = mNextState = g_animatestate[iState];
	mCurrentFrame = mCurrentState.start;
	mNextFrame = mCurrentState.start + 1;
	mInterpolation = 0.0f;

}



/********************************************************************/
/*																	*/
/* Function name : ChangeState										*/
/* Description   : Changes the animation state						*/
/*																	*/
/********************************************************************/
void MD2Model::ChangeState(int iState)
{
	if ((iState  > NumStates) || (iState < 0))
		iState = 0;

	mNextStateIndex = iState;
	mNextState = g_animatestate[iState];
	mNextFrame = mNextState.start;
	mInterpolation = 0.0f;
}



/********************************************************************/
/*																	*/
/* Function name : GetCurrentState									*/
/* Description   : Retrives the current animation state				*/
/*																	*/
/********************************************************************/
int MD2Model::GetCurrentState()
{
	return mCurrentStateIndex;
}


/********************************************************************/
/*																	*/
/* Function name : GetNextState										*/
/* Description   : Retrives the next animation state				*/
/*																	*/
/********************************************************************/
int MD2Model::GetNextState()
{
	return mNextStateIndex;
}
 

/********************************************************************/
/*																	*/
/* Function name : UpdateAnimation									*/
/* Description   : Updates the animation sequence					*/
/*																	*/
/********************************************************************/
void MD2Model::UpdateAnimation(int tcnt)
{
	DWORD t;

    if (tcnt > 0){
    	t = GetTickCount();
    	if (t < (mTick + tcnt))//tcnt is in ms 1 sec = 1000
    		return ;
    	mTick = t;
    }

	// Increase Interpolation
	mInterpolation += 0.25f;
	// If Interpolation overflowed, go to next frame
	if (mInterpolation > 1.0) {
		// Next frame is in the same state
		if (mCurrentState.start == mNextState.start) {
			mCurrentFrame = mNextFrame;
			mNextFrame = mCurrentFrame + 1;
		// Next Frame is in another state
		} else {
			mCurrentFrame = mNextState.start;
			mNextFrame = mCurrentFrame + 1;
			mCurrentState = mNextState;
		}
		// Check frame bounds
		if (mCurrentFrame >= mCurrentState.end || mNextFrame >= mCurrentState.end)
			mNextFrame = mCurrentState.start;
		if (mCurrentFrame > mCurrentState.end)
			mCurrentFrame = mCurrentState.end;
			// Reset the Interpolation

		if (mCurrentFrame >= NumFrames+1){
			mCurrentFrame = mCurrentState.start;
			mNextFrame = mCurrentFrame + 1;
		}
		mInterpolation = 0.0;
	}
}






/********************************************************************/
/*																	*/
/* Function name : ReadShort										*/
/* Description   : Reads a Short from a file						*/
/*																	*/
/********************************************************************/
short MD2Model::ReadShort(FILE *hfile)
{
	short value = 0;
	fread(&value, sizeof(short), 1, hfile);

	#if MD2_BYTEORDER == MD2_BIG_ENDIAN
	// value = MD2SwapShort(value);
	#endif

	return value;
}


/********************************************************************/
/*																	*/
/* Function name : ReadInt											*/
/* Description   : Reads a Int from a file							*/
/*																	*/
/********************************************************************/
int MD2Model::ReadInt(FILE *hfile)
{
	int value = 0;
	fread(&value, sizeof(int), 1, hfile);

	#if MD2_BYTEORDER == MD2_BIG_ENDIAN
	//value = MD2SwapInt(value);
	#endif

	return value;
}


/********************************************************************/
/*																	*/
/* Function name : ReadFloat										*/
/* Description   : Reads a Float from a file						*/
/*																	*/
/********************************************************************/
float MD2Model::ReadFloat(FILE *hfile)
{
	float value = 0;

	fread(&value, sizeof(float), 1, hfile);

	#if MD2_BYTEORDER == MD2_BIG_ENDIAN
	// value = MD2SwapFloat(value);
	#endif

	return value;
}




/********************************************************************/
/*																	*/
/* Function name : InitMD2											*/
/* Description   : Resets the obj index								*/
/*																	*/
/********************************************************************/
void InitMD2 ()
{
	int i;
	for (i = 0; i< MAXMODELS; i++)
		MD2ObjIndex[i] = -1;

}


/********************************************************************/
/*																	*/
/* Function name : ResetMD2index									*/
/* Description   : Resets the obj index	for used models				*/
/*																	*/
/********************************************************************/
void ResetMD2index ()
{
	int i;
	for (i = 0; i< MAXMODELS; i++){
		if (MD2ObjIndex[i] >= 0)
			MD2ObjIndex[i] = -2;//-2, loaded but not active
	}

}

/********************************************************************/
/*																	*/
/* Function name : MD2Draw											*/
/* Description   : Wrapper for obj draw								*/
/*																	*/
/********************************************************************/
void MD2Draw(int objnb, int md2state,int  md2scale,int md2xoff,int md2yoff,int md2zoff, int tcnt,double x,double y,double z,double xtile,double ytile,double ztile)
{  
	if (md2state != MD2ObjList[objnb].LastState){
		MD2ObjList[objnb].ChangeState (md2state);  
		MD2ObjList[objnb].LastState = md2state;
	} 

	if (strstr(MD2ObjList[objnb].ModelName,".MD2")==0){

		glRotatef(MD2ObjList[objnb].Xrot, 1.0f, 0.0f, 0.0f);
		glRotatef(MD2ObjList[objnb].Yrot, 0.0f, 1.0f, 0.0f);
		glRotatef(MD2ObjList[objnb].Zrot, 0.0f, 0.0f, 1.0f);
		glTranslated((GLdouble)(x/0x8000)-md2xoff,(GLdouble)(z/0x8000)-md2zoff,(GLdouble) (y/0x8000)-md2yoff);
		glScalef(MD2ObjList[objnb].Scale , MD2ObjList[objnb].Scale, MD2ObjList[objnb].Scale);

		DrawGLScene(objnb,MD2ObjList[objnb].ModelName,(float)x, (float)y, (float)z, (float)md2xoff, (float)md2yoff, (float)md2zoff);
		//DrawGLScene(xtile,ytile,ztile);
		//displayassimp(x,y,z);

		 


		return;
/*		if (m.Objects != 0){
			m.pos.x = (float)(x/1024)-(md2xoff/1024);;
			m.pos.y = (float)(y/1024)-(md2yoff/1024);;
			m.pos.z = (float)(z/1024)-(md2zoff/1024);
			// If you want to move or rotate individual objects
			for (int iu = 0;iu < m.numObjects;iu++){
				m.Objects[iu].rot.x = 90.0f;
				m.Objects[iu].rot.y = 0.0f;
				m.Objects[iu].rot.z = 0.0f;
			}
//			m.Draw(); // Renders the model to the screen
		}*/
	}else
		MD2ObjList[objnb].DrawMD2(  md2scale, md2zoff,tcnt);

	return;
}


/********************************************************************/
/*																	*/
/* Function name : LoadMD2Model										*/
/* Description   : Wrapper for LoadMD2Model 						*/
/*																	*/
/********************************************************************/

//C3DS *c3ds = new C3DS;
//int c3dsinit = 0;


int LoadMD2Model(char *fname, int md2state, char *extrainfo)
{
	int i;
	char *ptr;
	char pcxname[256];

	
	if (*fname == 0)
		return -1;

	lstrcpy(pcxname,fname);
	_strupr(pcxname);

	//try first to check if there is a model loaded but not used
	//there is no need to unload a unused model
	//and then later load it again, we just search the used models list
	//-2 = loaded but not used, -1 index is free and not loaded
	for (i = 0; i < MAXMODELS; i++){
		if (MD2ObjIndex[i] == -2){
			if (lstrcmpi(MD2ObjList[i].ModelName,fname)==0){
				MD2ObjIndex[i] = i;//mark at as used
				return i;
			}
		}
	}	
	
	//find free index nb in obj array
	for (i = 0; i< MAXMODELS; i++){
		if (MD2ObjIndex[i] == -1){
			MD2ObjIndex[i] = i;//mark at as used
			break;
		}
	}
	
    lstrcpy (MD2ObjList[i].ModelName,pcxname);	
    
	ptr = strstr(pcxname,".MD2");
	if (ptr == 0){
		//must be a 3ds, obj or other model
		//get the float scale value from xtra info
		ptr = strstr(extrainfo, "SC=");
		if (ptr != 0)
			MD2ObjList[i].Scale = (float)atof(ptr+3);
		ptr = strstr(extrainfo, "RX=");
		if (ptr != 0)
			MD2ObjList[i].Xrot = (float)atof(ptr+3);
		ptr = strstr(extrainfo, "RY=");
		if (ptr != 0)
			MD2ObjList[i].Yrot = (float)atof(ptr+3);
		ptr = strstr(extrainfo, "RZ=");
		if (ptr != 0)
			MD2ObjList[i].Zrot = (float)atof(ptr+3);

	
		Import3DAssimpModel(i,MD2ObjList[i].ModelName,GLPath);
			
			return i;
			//loadasset ("../../test/models/X/Testwuson.X");
		//return i;
/*			
			m.Load(fname); // Load the 3DS model	
			//get the float scale value from xtra info
			ptr = strstr(extrainfo, "SC=");
			if (ptr != 0)
				m.scale = (float)atof(ptr+3);
			ptr = strstr(extrainfo, "RX=");
			if (ptr != 0)
				m.rot.x = (float)atof(ptr+3);
			ptr = strstr(extrainfo, "RY=");
			if (ptr != 0)
				m.rot.y = (float)atof(ptr+3);
			ptr = strstr(extrainfo, "RZ=");
			if (ptr != 0)
				m.rot.z = (float)atof(ptr+3);

			return i;
		*/
		return -1;
	}
	*ptr = 0;//cut of .md2
	//make the texturename
	//lstrcat(pcxname,".pcx");
	_strupr(pcxname);

	MD2ObjList[i].Load(fname, pcxname, md2state);
	return i;

 }

long MD2Model::PutFacesXYZ(long numObj,float mi0, float mi1, float mi2, float to0, float to1, float to2)
{	
	PolygonsIndex[numObj].meshindex[0] = (unsigned short) mi0;
	PolygonsIndex[numObj].meshindex[1] = (unsigned short)mi1;
	PolygonsIndex[numObj].meshindex[2] = (unsigned short)mi2;
	PolygonsIndex[numObj].toiindex[0]  = (unsigned short)to0;
	PolygonsIndex[numObj].toiindex[1]  = (unsigned short)to1;
	PolygonsIndex[numObj].toiindex[2]  = (unsigned short)to2;
	return 0;
} 


long MD2Model::PutVertexXYZ(long numObj, long v, float vertsx, float vertsy, float vertsz)
{	
	VertexList[v].point[0] = vertsx;
	VertexList[v].point[1] = vertsy;
	VertexList[v].point[2] = vertsz;
	return 0;
}


void MD2Model::SetNumVertices(long numv)
{
	NumVertices = numv;
}


void MD2Model::SetNumFrames(long numv)
{
	NumFrames = numv;
}


void MD2Model::SetNumPolygons(long numv)
{
	NumPolygons = numv;
}


/********************************************************************/
/*																	*/
/* Function name : GetActorDir										*/
/* Description   : Finds a actors direction in 0 360				*/
/*																	*/
/********************************************************************/
int GetActorDir (dirtype dir)
{
	int dirang = 0;

	switch (dir) {   
		case east:
			dirang = 0;break;// (double)0 *    (360.0/FINEANGLES);break;
		case northeast:
			dirang = 315; break;//  (double)256 *  (360.0/FINEANGLES);break;
		case north:
			dirang = 270;break;// (double)512 *  (360.0/FINEANGLES);break;
		case northwest:
			dirang = 225; break;//  (double)768 *  (360.0/FINEANGLES);break;
		case west:
			dirang = 180;break;//  (double)1024 * (360.0/FINEANGLES);break;
		case southwest:
			dirang = 135 ;break;//  (double)1280 * (360.0/FINEANGLES);break;
		case south:
			dirang = 90;break;//  (double)1536 * (360.0/FINEANGLES);break;
		case southeast:
			dirang = 45; break;//  (double)1792 * (360.0/FINEANGLES);break;
	}
	return dirang;

}




/********************************************************************/
/*																	*/
/* Function name : GetActorDir										*/
/* Description   : Trys to smoot actors turning (allways 45 degress)*/
/*																	*/
/********************************************************************/
int GetActorFineTurnAngle (objtype *obj)
{
	int ang;

	ang = 0;
	
	if (obj->isturning == 0){
		ang = GetActorDir (obj->dir);//0 til 360
		if (ang != obj->lastang){//STM();
			obj->dirfrom = obj->lastang;
			obj->dirto = ang;
			//find turn direction (5*9 = 45 degrees)
			if (obj->dirfrom - obj->dirto <= -180) obj->isturning = -5;//1 = --
			else if (obj->dirfrom - obj->dirto >= 180) obj->isturning = 5;//2 = ++
			else if (obj->dirfrom - obj->dirto <= 0) obj->isturning = 5;//2 = ++
			else if (obj->dirfrom - obj->dirto > 0) obj->isturning = -5;//1 = --
		}
	}else{
		//we are turning
		if (obj->isturning < 0){
			obj->isturning++;
			//counting down
			obj->dirang -= 9;
			if (obj->dirang <= 0)
				obj->dirang = 351;
			if (obj->dirang == obj->dirto)
				obj->isturning = 0;
		}else if (obj->isturning > 0){
			obj->isturning--;
			//counting up
			obj->dirang += 9;
			if (obj->dirang >= 360)
				obj->dirang = 0;
			if (obj->dirang == obj->dirto)
				obj->isturning = 0;
		}
		obj->lastang = obj->dirang;
		if (obj->dirang > 360)
			obj->dirang = 0;
		if (obj->dirang < 0)
			obj->dirang = 0;
	}

	return obj->dirang;
}




/********************************************************************/
/*																	*/
/* Function name : GetModelInfo										*/
/* Description   : Retrives info form char name						*/
/*																	*/
/********************************************************************/
int GetModelInfo (objtype *obj, char *name)
{
	char tmp[256];
	char *ptr,*ptr2,*p;
//	int md2xoff, md2yoff;

	//---------------------------------
	//check if its one of ours from model.ifo
	lstrcpy(tmp,name);
	_strupr(tmp);

	obj->md2rotate = 0;

	//is there a weaponname included
	ptr2 = strstr(tmp,":");
	if (ptr2 != 0){
		*ptr2 = 0;
		lstrcpy (obj->md2Name,tmp);
		//yes we have a weaponname, find end of name
		ptr = strstr(ptr2+1,"|");
		if (ptr > ptr2+1){
			*ptr = 0;
			lstrcpy (obj->md2WName,ptr2+1);
			ptr++;
		}
	}else{
		//no weapon included, just copy modelname
		ptr = strstr(tmp,"|");
		if (ptr == 0)return 0;*ptr = 0;lstrcpy (obj->md2Name,tmp);}
	//find rest of info
	//find state
	obj->md2state = 0;
	p = strstr(ptr,"ST=");
	if (p != 0) 
		obj->md2state = atol(p+3);

	//find scale
	obj->md2scale = 0;
	p = strstr(ptr,"SC=");
	if (p != 0) 
		obj->md2scale = atol(p+3);

	//find x offset
	obj->md2xoff = 0;
	p = strstr(ptr,"XO=");
	if (p != 0) 
		obj->md2xoff = atol(p+3);

	//find y offset
	obj->md2yoff = 0;
	p = strstr(ptr,"YO=");
	if (p != 0) 
		obj->md2yoff = atol(p+3);

	//find z offset
	obj->md2zoff = 0;
	p = strstr(ptr,"ZO=");
	if (p != 0) 
		obj->md2zoff = atol(p+3);

	//find tickcount
	obj->md2tcnt = 0;
	p = strstr(ptr,"TK=");
	if (p != 0) 
		obj->md2tcnt = atol(p+3);

	//find rotate
	obj->md2rotate = 0;
	p = strstr(ptr,"RO");
	if (p != 0) 
		obj->md2rotate = 1;



	return 1;


}







/********************************************************************/
/*																	*/
/* Function name : MD2refresh										*/
/* Description   : Retrives info form char name						*/
/*																	*/
/********************************************************************/
int MD2refresh (unsigned int id ,char *name,double x,double y,double z,double angle)
{


	double rotate=0;
//	statobj_t *statmd2ptr;
    objtype *obj;
//    maskedwallobj_t *tmwall;

	//is this a MD2 model?  
	if (strchr(name,'|')==0){
		//there is only a | in md2 names
		return 0;
	}
		
	if (id > 0){//do we have a object attaced to it?
		obj = (objtype *) id ;//incl both statptr and obj (top of struct is alike)
/*		if (obj->which == MWALL){
			tmwall = (maskedwallobj_t *)id;
//			glvisobj *cvis = visobjects;
			return 1;
		}*/
		//lumpinfo[tmwall->bottomtexture].mod;
		if ((obj->which == SPRITE)||(obj->which == MWALL)){//md2fix 
			if ((obj->MD2pointer > 2048)||(obj->MD2pointer < 0))//bna++154
				obj->MD2pointer = 0;//bna++154
			if (obj->MD2pointer == 0){
				GetModelInfo (obj, name);
				obj->MD2pointer = LoadMD2Model(obj->md2Name, obj->md2state,name) + 1;//eg = lamp.md2
				if (obj->MD2pointer == 0)//bna++154
					return 0;//bna++154
			}

			if (obj->md2rotate > 0) {
				rotate += GetTicCount()*3.0;
			}else //if we dont rotate just set angle to 180
				rotate = obj->angle;//154 code//rotate = 180;
		
			
			/*
	
			int gmwd = GetRailingDir(obj->tilex, obj->tilex, mw_railing,MW_ABOVEPASSABLE | MW_MIDDLEPASSABLE);
			if (gmwd == 1)
				rotate = 90;
*/

			glRotated(rotate,0,0,1);
			glTranslated((GLdouble)(x/0x8000)-obj->md2xoff,(GLdouble)(y/0x8000)-obj->md2yoff,(GLdouble) (z/0x8000)-obj->md2zoff);
				
			MD2Draw(obj->MD2pointer - 1, obj->md2state , obj->md2scale, obj->md2xoff, obj->md2yoff, obj->md2zoff,obj->md2tcnt, x, y, z,obj->x,obj->y,obj->z );

		}else if (obj->which == ACTOR){//STM();//md2fix
			//has this obj a model attached to it, else load one
			if (obj->MD2pointer == 0){
				GetModelInfo (obj, name);
				obj->MD2pointer = LoadMD2Model(obj->md2Name, obj->md2state,name) + 1;//eg = Trooper.md2
				if (obj->md2WName[0] != 0)
					obj->MD2Wpointer = LoadMD2Model(obj->md2WName, obj->md2state,name) + 1;//eg = Trooper.md2
			}
			//obj->dirang = GetActorDir (obj->dir);//0 til 360
			obj->dirang = GetActorFineTurnAngle(obj);//0 til 360
			glRotated(obj->dirang,0,0,1);
			
			GetModelInfo (obj, name);		
			glTranslated((GLdouble)(x/0x8000)-obj->md2xoff,(GLdouble)(y/0x8000)-obj->md2yoff,(GLdouble) (z/0x8000)-obj->md2zoff);

			MD2Draw(obj->MD2pointer - 1, obj->md2state , obj->md2scale, obj->md2xoff,obj->md2yoff,obj->md2zoff,obj->md2tcnt, x, y, z ,obj->x,obj->y,obj->z );

			if (obj->md2WName[0] != 0)				
				MD2Draw(obj->MD2Wpointer - 1, obj->md2state ,obj->md2scale, obj->md2xoff,obj->md2yoff,obj->md2zoff,obj->md2tcnt, x, y, z ,obj->x,obj->y,obj->z );
		}
	}
	glPopMatrix();
	glEnable(GL_CULL_FACE);
	return 1;

}



void LoadT3Dmodel()
{
	FILE	*instream;
	char	line[1024];
//	char	linebuf[10240];
//	char	RetStr[1024];
	char    *s,*ret;
	int		i=0,p=0,w,h,cnt=0,pol=-1;
	float x,y,z;
	MD2Vector vertex[4]; 
	GLfloat fNormalX, fNormalY, fNormalZ;

//GetUnrealT3Dlevel("c:\\WinRott_2.24_GL\\test.t3d");
	
	
	//return ;//no t3d file


	if( (instream  = fopen( "c:\\WinRott_2.24_GL\\test.t3d", "rt" )) == NULL ) {
		return ;//no t3d file
	}
		





	//load the texture
	if (T3D_Tex == 0)
		T3D_Tex = LoadModelTexture("c:\\WinRott_2.24_GL\\Wall31.bmp",1,20,&w,&h);  
	glBindTexture(GL_TEXTURE_2D, T3D_Tex);
	//draw the Model
	glBegin(GL_TRIANGLES);
	while (!feof(instream)) {
		cnt++;
		do { //read header in
				strcpy(line,"");
				fgets( line, 1023, instream );
				if (feof(instream)){ 
					fclose(instream);
					return ;
				}
		}while (strstr (line, "TextureV")==0);
		i = 0;p++;pol++;
		do {//read all data for 1 brush polygon in buffer
			strcpy(line,"");
			ret = fgets( line, 1023, instream );
			s = strstr(line,"Vertex");
			if ((s==0)||(ret == NULL)){
				T3Dpolygons[pol].numofvertex = i;
				break;
			}
			x = (float)atof(s+6);

			s = strstr(line,",");
			if (s==0)
				break;
			y = (float)atof(s+1);

			s = strstr(s+2,",");
			if (s==0)
				break;
			z = (float)atof(s+1);
/*
			vertex[i].point[0] = (float)x/1;
			vertex[i].point[1] = (float)y/1;
			vertex[i].point[2] = (float)z/1;
*/

			T3Dpolygons[pol].vertex[i].point[0] = (float)x/1;
			T3Dpolygons[pol].vertex[i].point[1] = (float)y/1;
			T3Dpolygons[pol].vertex[i].point[2] = (float)z/1;
			i++;

		}while ((i<40)&&(!feof(instream)));

		if ((i > 3)&&(cnt>-1)){
			//its a square, make it 2 triangles
			glTexCoord2f(0.f,1.f);
			glVertex3fv(vertex[3].point);
			glTexCoord2f(0.f,0.f);
			glVertex3fv(vertex[2].point);
			glTexCoord2f(1.f,1.f);
			glVertex3fv(vertex[0].point);	
			CalculateVectorNormal(vertex[0].point, vertex[2].point, vertex[3].point, &fNormalX,
								&fNormalY, &fNormalZ);
			// Set the normal vector for the polygon
			glNormal3f(fNormalX, fNormalY, fNormalZ);
		}//else{

			glTexCoord2f(0.f,0.f);
			glVertex3fv(vertex[2].point);
			glTexCoord2f(1.f,0.f);
			glVertex3fv(vertex[1].point);
			glTexCoord2f(1.f,1.f);
			glVertex3fv(vertex[0].point);	

		//}
			// Calculate the vector normal coming out of the 3D polygon.
			CalculateVectorNormal(vertex[0].point, vertex[1].point, vertex[2].point, &fNormalX,
								&fNormalY, &fNormalZ);
			// Set the normal vector for the polygon
			glNormal3f(fNormalX, fNormalY, fNormalZ);


	}
	fclose(instream);

	p = 0;

}


   //*******************************************************************
   // Function: CalculateVectorNormal
   // 
   // Purpose: Given three points of a 3D plane, this function calculates
   //          the normal vector of that plane.
   // 
   // Parameters:
   //     fVert1[]   == array for 1st point (3 elements are x, y, and z).
   //     fVert2[]   == array for 2nd point (3 elements are x, y, and z).
   //     fVert3[]   == array for 3rd point (3 elements are x, y, and z).
   // 
   // Returns:
   //     fNormalX   == X vector for the normal vector
   //     fNormalY   == Y vector for the normal vector
   //     fNormalZ   == Z vector for the normal vector
   // 
   // Comments:
   // 
   // History:  Date       Author        Reason
   //           3/22/95     GGB           Created
   //**********************************************************************

   GLvoid CalculateVectorNormal(GLfloat fVert1[], GLfloat fVert2[],

                             GLfloat fVert3[], GLfloat *fNormalX,
                             GLfloat *fNormalY, GLfloat *fNormalZ)
    {
    GLfloat Qx, Qy, Qz, Px, Py, Pz;

   Qx = fVert2[0]-fVert1[0];
   Qy = fVert2[1]-fVert1[1];
   Qz = fVert2[2]-fVert1[2];
   Px = fVert3[0]-fVert1[0];
   Py = fVert3[1]-fVert1[1];
   Pz = fVert3[2]-fVert1[2];

   *fNormalX = Py*Qz - Pz*Qy;
   *fNormalY = Pz*Qx - Px*Qz;
   *fNormalZ = Px*Qy - Py*Qx;

   } 


void MakeBrushToTriangles()
{

}
// this section reads a unreal T3d file in to arrays (wad format)


int GetUnrealT3Dlevel(char *fname)
{
	char *b;
	FILE *instream;
	int NbOfVertexInPolygon = 0;
	int NbOfPolygons = 0;
	int bufsize;

	if( (instream  = fopen(fname, "rt" )) == NULL ) {
		return -1;//no t3d file
	}

	//get needed bufsize
	bufsize = ReadPolygonTextIn(instream,0);
	//b = (char*)GlobalAlloc(GMEM_FIXED|GMEM_ZEROINIT,bufsize);
	b = (char*)HEAP_getheapmem(bufsize);

	//count nb of vertexes in brush
	NbOfVertexInPolygon = ReadPolygonTextIn(instream,b);

	// now we can redim our arrays in order to hold our data
/*	Polygon1 = new polygon[NbOfPolygons];
	Polygon1->v->x = 0;
	Polygon1->v->y = 0;
	Polygon1->v->z = 0;
	while (!feof(instream)) {
		cnt++;
		do { //read header in
				strcpy(linebuf,"");
				fgets( line, 1023, instream );
				if (feof(instream)){ 
					fclose(instream);
					return ;
				}
		}while (strstr (line, "TextureV")==0);
		i = 0;p++;
		do {//read all data for 1 brush polygon in buffer
			strcpy(linebuf,"");
			fgets( line, 1023, instream );
			s = strstr(line,"Vertex");
			if (s==0)
				break;
			x = atof(s+6);

			s = strstr(line,",");
			if (s==0)
				break;
			y = atof(s+1);

			s = strstr(s+2,",");
			if (s==0)
				break;
			z = atof(s+1);

			vertex[i].point[0] = (float)x/1;
			vertex[i].point[1] = (float)y/1;
			vertex[i].point[2] = (float)z/1;
			i++;



		}while ((i<4)&&(strstr(line,"Vertex")!=0)&&(!feof(instream)));

		*/
	return -1;
}

/*
int LoadT3Dmodel(char *fname)
{
//	FILE instream;
	/*
	if( (instream  = fopen(fname, "rt" )) == NULL ) {
		return -1;//no t3d file
	}

return -1;

}
*/
int ReadPolygonTextIn(FILE *f, char *buf)
{
	//caller must supply mem to store text
	//returns nb of vertex in polygon
	//if buf = 0 func returns size of text
	char linebuf[256],*s;
	int cnt = 0;
	fpos_t pos;

    if( fgetpos( f, &pos ) != 0 )
         return -1;
	
	if (buf > 0)
		*buf = 0;

	//get polygon text from brush
	while (!feof(f)) {
			linebuf[0] = 0;
			fgets( linebuf, sizeof(linebuf), f );
			s = strstr(linebuf,"Vertex");
			if (s!=0)//cnt nb of vertex in this polygon
				cnt++;
			if (buf > 0){
				lstrcat (buf,linebuf);
				lstrcat (buf,"\n");
			}else
				cnt += lstrlen(linebuf);
			s = strstr(linebuf,"End Polygon");
			if (s!=0)
				break;
	}
			
	if (buf > 0){
		return cnt;
	}else{
		int weds = fseek(f,(long)pos,SEEK_SET);
		return cnt;
	}
}


