

/******************************************************************************
 
 MD2Loader.h

 Copyright  2006, Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://home14.inet.tele.dk/Bna-Info
 
/******************************************************************************/



#include "vector.h"


// structure to hold texture coordinates
typedef struct
{
	float s;
	float t;
} MD2TextureCoord;

// structure to hold texture coordinate index
typedef struct
{
	short s;
	short t;
} MD2TexCoordIndex;

// structure to hold information for a single frame point
typedef struct
{
	unsigned char v[3];
	unsigned char normalindex; // not used
} MD2FramePoint;

// structure to hold information for a single frame
typedef struct
{
	float scale[3];
	float translate[3];
	char  name[16];
	MD2FramePoint * fp; 
} MD2Frame;

// structure to hold data for a single triangle (polygon)
typedef struct
{
	unsigned short toiindex[3]; // texture coordinate indices
	unsigned short meshindex[3];// vertex indices
} MD2Mesh;


typedef struct
{
	int ident;				// This is used to identify the MD2 file "IDP2".
	int version;			// The version number of the file (Must be 8).
	int skinwidth;			// The skin width in pixels.
	int skinheight;			// The skin height in pixels.
	int framesize;			// The size in bytes the frames are.
	int NumSkins;			// The number of skins associated with the model.
	int NumVertices;		// The number of vertices (constant for each frame).
	int NumTexCoords;		// The number of texture coordinates.
	int NumPolygons;		// The number of faces (triangles).
	int NumGLCmds;			// The number of OpenGL commands.
	int NumFrames; 			// The number of animation frames.
	int offsetSkins;		// The offset to skin names (64 bytes each).
	int offsetST;			// The offset in the file for the texture datas.
	int offsetPolygons;		// The offset of triangle meshes.
	int offsetFrames;		// The offset in the file for the frames data(points).
	int offsetGLCmds;		// The type of OpenGL commands to use.
	int offsetEndOfFile;	// The end of file offset.
} MD2ModelHeader;
		


// animation
typedef struct
{
    int     start;          // first frame of the animation
    int     end;            // number of frames
    int     fps;            // number of frames per second
	char    statename[16];

} AnimateState;


AnimateState g_animatestate[ 21 ] = 
{
    // first, last, fps
    { 0, 0, 0, 0 },   // STAND
    { 0, 0, 0, 0  },   // RUN
    { 0, 0, 0, 0  },   // ATTACK
    { 0, 0, 0, 0  },   // PAIN_A
    { 0, 0, 0, 0  },   // PAIN_B
    { 0, 0, 0, 0  },   // PAIN_C
    { 0, 0, 0, 0  },   // JUMP
    { 0, 0, 0, 0  },   // FLIP
    { 0, 0, 0, 0  },   // SALUTE
    { 0, 0, 0, 0  },   // FALLBACK
    { 0, 0, 0, 0  },   // WAVE
    { 0, 0, 0, 0  },   // POINT
    { 0, 0, 0, 0  },   // CROUCH_STAND
    { 0, 0, 0, 0  },   // CROUCH_WALK
    { 0, 0, 0, 0  },   // CROUCH_ATTACK
    { 0, 0, 0, 0  },   // CROUCH_PAIN
    { 0, 0, 0, 0  },   // CROUCH_DEATH
    { 0, 0, 0, 0  },   // DEATH_FALLBACK
    { 0, 0, 0, 0  },   // DEATH_FALLFORWARD
    { 0, 0, 0, 0  },   // DEATH_FALLBACKSLOW
    { 0, 0, 0, 0  },   // BOOM
};



class MD2Model 
{
	public:

		MD2Model();
		~MD2Model();
		bool  Load(char *modelFile, char *skinFile, int md2state);
		void  DrawMD2(int  md2scale,int md2zoff,int tcnt);
		void  ReadHeader(FILE *hfile, MD2ModelHeader & header);
		void  CalcNormal( float *p1, float *p2, float *p3 );
		void  SetState(int pState);
		void  ChangeState(int pState);
		int   GetCurrentState();
		int   GetNextState();
		void  UpdateAnimation(int tcnt);
		short ReadShort(FILE *hfile);
		int   ReadInt(FILE *hfile);
		float ReadFloat(FILE *hfile);
		int   LastState;
		
        char  ModelName[64];	

		float Xrot;
		float Yrot;
		float Zrot;
		float Scale;

		long PutFacesXYZ(long numObj, float mi0, float mi1, float mi2, float to0, float to1, float t032);
		long PutVertexXYZ(long numObj, long v, float vertsx, float vertsy, float vertsz);
		void SetNumPolygons(long numv);
		void SetNumFrames(long numv);
		void SetNumVertices(long numv);

	private:
		int	  mCurrentFrame;
		int	  mNextFrame;
		float mInterpolation;
		int	  mCurrentStateIndex;
		int	  mNextStateIndex;
		DWORD mTick;
		DWORD mTickLast;
		int   NumStates;
		int   NumFrames;
		int   NumVertices;
		int   NumPolygons;
		int   NumTexCoords;
		int   FrameSize;
		int   ModelTex;




		AnimateState mCurrentState;
		AnimateState mNextState;

		MD2Mesh *PolygonsIndex;
		MD2TextureCoord * TextureCoords;
		MD2Vector *VertexList;

};









