////////////////////////////////////////////////////////////////////////////////
// MP3.cpp
//
//  MP3-handling code, using DirectShow

#define WIN32_LEAN_AND_MEAN

#define DIRECTINPUT_VERSION 0x0800

#include <windows.h>
#include <tchar.h>
#include <ddraw.h>
#include <dinput.h>
#include <dmusicc.h>
#include <dmusici.h>
#include <dshow.h>
#include <stdarg.h>
#include <stdio.h>
#include <malloc.h>
#include <io.h>

#include "resource.h"
#include "MP3.h"

//#include "Window.h"
//#include "Debug.h"

// Force the inclusion of the libraries we need
#pragma comment(lib, "kernel32.lib")
#pragma comment(lib, "ole32.lib")
#pragma comment(lib, "amstrmid.lib")

BOOL InitMP3();
extern "C"{
	extern void WriteLBtext(LPSTR txt);
	extern HWND hMainWnd;
	void MP3musicStopSong();
	void MP3musicPlay(LPSTR name);
	void MP3musicPlaySound(LPSTR name);
	int  MP3SetVolume(long lVolume);
	extern char Mp3Path[256];
	void HandleMP3Events();
	BOOL IsMp3MusicPlaying();
	void StopMP3();
	void ExitMP3();
	extern int MUvolume;

	extern char ApogeePath[256];
	extern int iUseMp3Music;
	extern long LoadResourceToFixedMem (LPSTR Type ,int sndnb, void **bufferptr);
		
	char Thunderpath1[256];//
	char Thunderpath2[256];//
	char Thunderpath3[256];//
	char Waterpath3[256];//
}
IMediaSeeking   *g_pMediaSeeking;
void OnMP3Finish(long);
BOOL IsMP3Init = 0;
IBaseFilter *pS;
LONGLONG lG;

////////////////////////////////////////////////////////////////////////////////
// Sound and music support

IGraphBuilder   *g_pGraphBuilder;
IMediaControl   *g_pMediaControl;

IMediaEventEx   *g_pMediaEventEx;

BOOL InitMP3()
{
    HRESULT h;
	int size = 0;


		//if (sndnum==252)
//SD_LIGHTNINGSND

    // Initialise COM, so that we can use CoCreateInstance.
    ::CoInitialize(NULL);
    
    // Create an IGraphBuilder object, through which 
    //  we will create a DirectShow graph.
    h = CoCreateInstance(CLSID_FilterGraph, NULL,
                                      CLSCTX_INPROC, IID_IGraphBuilder,
                                      (void **)&g_pGraphBuilder);
    if (FAILED(h))
    {
        //DISPLAYERRORCODE(h, "DirectShow could not be initialised. DirectX 8 may not be installed.");
        return FALSE;
    }

    // Get the IMediaControl Interface
    h = g_pGraphBuilder->QueryInterface(IID_IMediaControl,
                                 (void **)&g_pMediaControl);
    if (FAILED(h))
    {
        //DISPLAYERRORCODE(h, "DirectShow could not be initialised. DirectX 8 may not be installed.");
        return FALSE;
    }

    // Get the IMediaSeeking Interface
    h = g_pGraphBuilder->QueryInterface(IID_IMediaSeeking,
                                 (void **)&g_pMediaSeeking);
    if (FAILED(h))
    {
        //DISPLAYERRORCODE(h, "DirectShow could not be initialised. DirectX 8 may not be installed.");
        return FALSE;
    }

    // Get the IMediaEventEx Interface
    h = g_pGraphBuilder->QueryInterface(IID_IMediaEventEx,
                                 (void **)&g_pMediaEventEx);
    if (FAILED(h))
    {
        //DISPLAYERRORCODE(h, "DirectShow could not be initialised. DirectX 8 may not be installed.");
        return FALSE;
    }
    g_pMediaEventEx->SetNotifyWindow((OAHWND)hMainWnd, WM_APP, 0);



    return TRUE;
}

IBaseFilter *LoadMP3(LPCWSTR wszFilename)
{
    IBaseFilter *pSource;
    HRESULT     h;

    // Add the new source filter to the graph.
    h = g_pGraphBuilder->AddSourceFilter(wszFilename, wszFilename, &pSource);
    if (FAILED(h))
        return NULL;

    return pSource;
}

void PlayMP3(IBaseFilter *pSource)
{
    IPin            *pPin = NULL;
    IEnumFilters    *pFilterEnum = NULL;
    IBaseFilter     **ppFilters;
    IBaseFilter     *pFilterTemp = NULL;
    int             iFiltCount;
    int             iPos;

    // Get the first output pin of the new source filter. Audio sources 
    // typically have only one output pin, so for most audio cases finding 
    // any output pin is sufficient.
    pSource->FindPin(L"Output", &pPin);  

    // Stop the graph
    g_pMediaControl->Stop();

    // Break all connections on the filters. You can do this by adding 
    // and removing each filter in the graph

    g_pGraphBuilder->EnumFilters(&pFilterEnum);
    
    // Need to know how many filters. If we add/remove filters during the
    // enumeration we'll invalidate the enumerator
    for (iFiltCount = 0; pFilterEnum->Skip(1) == S_OK; iFiltCount++)
        ;

    // Allocate space, then pull out all of the 
    ppFilters = (IBaseFilter **)_alloca(sizeof(IBaseFilter *) * iFiltCount);

    pFilterEnum->Reset();

    for (iPos = 0; pFilterEnum->Next(1, &ppFilters[iPos], NULL) == S_OK; iPos++)
        ;
    
    pFilterEnum->Release();

    for (iPos = 0; iPos < iFiltCount; iPos++) 
    {
        g_pGraphBuilder->RemoveFilter(ppFilters[iPos]);
        
        // Put the filter back
        g_pGraphBuilder->AddFilter(ppFilters[iPos], NULL);

        ppFilters[iPos]->Release();
    }

    // We have the new output pin. Render it
    g_pGraphBuilder->Render(pPin);

    pPin->Release();

    // Re-seek the graph to the beginning
    LONGLONG llPos = 0;
    g_pMediaSeeking->SetPositions(&llPos, AM_SEEKING_AbsolutePositioning,
                                &llPos, AM_SEEKING_NoPositioning);

	MP3SetVolume(MUvolume);
    // Start the graph
    g_pMediaControl->Run();
}

void ReplayMP3()
{
    if (g_pMediaControl != NULL)
    {
        // Re-seek the graph to the beginning
        LONGLONG llPos = 0;
        g_pMediaSeeking->SetPositions(&llPos, AM_SEEKING_AbsolutePositioning,
                                    &llPos, AM_SEEKING_NoPositioning);
 
        // Start the graph 
        g_pMediaControl->Run();
    }
}

void StopMP3()
{
    // Stop the graph
    if (g_pMediaControl != NULL)
        g_pMediaControl->Stop();

}

void ExitMP3()
{
    if (g_pMediaEventEx != NULL)
    {
        g_pMediaEventEx->Release();
        g_pMediaEventEx = NULL;
    }
    if (g_pMediaSeeking != NULL)
    {
        g_pMediaSeeking->Release();
        g_pMediaSeeking = NULL;
    }
    if (g_pMediaControl != NULL)
    {
        g_pMediaControl->Release();
        g_pMediaControl = NULL;
    }
    if (g_pGraphBuilder != NULL)
    {
        g_pGraphBuilder->Release();
        g_pGraphBuilder = NULL;
    }
	IsMP3Init = 0;
}

void HandleMP3Events()
{
    long    evCode, param1, param2;
    HRESULT h;

    for (;;)
    { 
        h = g_pMediaEventEx->GetEvent(&evCode, &param1, &param2, 0);
        if (FAILED(h))
            return;
        
        g_pMediaEventEx->FreeEventParams(evCode, param1, param2);
        OnMP3Finish(evCode);
    } 
}


void OnMP3Finish(long)
{
    // Restart background music if it has stopped
   // if (g_bMusicEnabled)
        ReplayMP3();
}



void MP3musicPlay(LPSTR name)
{
	char mp3path[256],*p;
	WCHAR wFile[MAX_PATH];
	LONGLONG pD;

	StopMP3(); 

	if (IsMP3Init == 0){
		IsMP3Init = 1;
		if (InitMP3()==0){
			iUseMp3Music = 0;
			return;
		}
	}

	lstrcpy(mp3path,Mp3Path);
	lstrcat(mp3path,name);
	p = mp3path + lstrlen(mp3path) - 4;
	if (lstrcmpi(p,".mp3")!=0)
		lstrcat(mp3path,".mp3");


	//WriteLBtext(mp3path);
	MultiByteToWideChar(CP_ACP, 0, mp3path, -1, wFile, MAX_PATH);

	pS = LoadMP3(wFile);
	if (pS == 0)
		return;


	PlayMP3(pS);

	g_pMediaSeeking->GetDuration(&lG);
	g_pMediaSeeking->GetCurrentPosition(&pD);
/*

	mp.Pause();
	mp.GetState();

	mp.StopWhenReady();
	mp.Stop();
	mp.Cleanup();

	
//	mp.ready = 0;
	mp.Load(mp3path);
	mp.Play();
*/
}


void MP3musicPlaySound(LPSTR name)
{
	WCHAR wFile[MAX_PATH];
	LONGLONG pD;

	//StopMP3(); 
	if (IsMP3Init == 0){
		IsMP3Init = 1;
		if (InitMP3()==0){
			iUseMp3Music = 0;
			return;
		}
	}
	MultiByteToWideChar(CP_ACP, 0, name, -1, wFile, MAX_PATH);
	pS = LoadMP3(wFile);
	if (pS == 0)
		return;
	PlayMP3(pS);
	g_pMediaSeeking->GetDuration(&lG);
	g_pMediaSeeking->GetCurrentPosition(&pD);

}

void MP3musicStopSong()
{
//	StopMP3(); 


/*	mp.Pause();
	mp.StopWhenReady();
	mp.Stop();
	mp.Cleanup();
	mp.Load("");
	mp.Play();*/
}


BOOL IsMp3MusicPlaying()
{
	LONGLONG pD;
	if (g_pMediaSeeking != 0){
		g_pMediaSeeking->GetCurrentPosition(&pD);
		if (pD+50000 >= lG){    
			return 0;
		}


	}
	return 1;
}




int MP3SetVolume(long lVolume)
{

	long lVol;
	IBasicAudio* pBA;
	if (g_pGraphBuilder == 0)
		return 0;
	HRESULT hrErr = g_pGraphBuilder->QueryInterface(IID_IBasicAudio,(void**)&pBA);
	if(FAILED(hrErr)) 
		return 0;
		
	//0 -> 254
 
	lVol = ((255-lVolume)*-8);
	if(lVol >      0) lVol = 0;
	if(lVol < -10000) lVol = -10000;

	hrErr = pBA->put_Volume(lVol);
	pBA->Release();
	if(FAILED(hrErr)) 
		return 0;

	return 1;
}

