
/******************************************************************************
 Actors_net.c 

 Copyright  2004, Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://home14.inet.tele.dk/Bna-Info
 ******************************************************************************/



void SpawnNetPatrol (classtype which, int tilex, int tiley, int dir);
void SpawnNetStand (classtype which, int tilex, int tiley, int dir, int ambush);
void SetupNetActors(void);



// if we want actors in net game we must create all actors without
// random factors or game will crash
// see void SetupActors(void)


void SetupNetActors(void)
{
  int i,j;
  word *map,tile;
  int starti;


  //GetRainActors();

  map = mapplanes[1];
  map+=5;

  for (j=0;j<mapheight;j++)
		{
		if (j==0)
			starti=5;
		else
			starti=0;
		for(i=starti;i<mapwidth;i++)
			{
			tile= *map++;

			switch(tile)
			  {

				case 126:
				case 127:
				case 128:
				case 129:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 108:
				case 109:
				case 110:
				case 111:
					SpawnNetStand(lowguardobj,i,j,tile-108,0);
					break;




				case 130:
				case 131:
				case 132:
				case 133:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 112:
				case 113:
				case 114:
				case 115:
					SpawnNetPatrol(lowguardobj,i,j,tile-112);
					break;

				case 134:
				case 135:
				case 136:
				case 137:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 116:
				case 117:
				case 118:
				case 119:
					SpawnNetStand(lowguardobj,i,j,tile-116,1);
					break;

				case 138:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 120:
					SpawnSneaky(i,j);//no random factors
					break;

				case 162:
				case 163:
				case 164:
				case 165:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 144:
				case 145:
				case 146:
				case 147:
					SpawnNetStand(highguardobj,i,j,tile-144,0);
					break;

				case 170:
				case 171:
				case 172:
				case 173:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 152:
				case 153:
				case 154:
				case 155:
					SpawnNetStand(highguardobj,i,j,tile-152,1);
					break;



				case 166:
				case 167:
				case 168:
				case 169:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 148:
				case 149:
				case 150:
				case 151:
					SpawnNetPatrol(highguardobj,i,j,tile-148);
					break;

				case 176:
				case 177:
				case 178:
				case 179:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 158:
				case 159:
				case 160:
				case 161:
					SpawnNetPatrol(roboguardobj,i,j,tile-158);
					break;

				case 212:
				case 213:
				case 214:
				case 215:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 194:
				case 195:
				case 196:
				case 197:
					SpawnGunThingy(patrolgunobj,i,j,tile-194);
					break;

				case 198:
				case 199:
				case 200:
				case 201:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 180:
				case 181:
				case 182:
				case 183:
					SpawnNetStand(strikeguardobj,i,j,tile-180,0);
					break;

				case 206:
				case 207:
				case 208:
				case 209:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 188:
				case 189:
				case 190:
				case 191:
					SpawnNetStand(strikeguardobj,i,j,tile-188,1);
					break;

				case 202:
				case 203:
				case 204:
				case 205:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 184:
				case 185:
				case 186:
				case 187:
					SpawnNetPatrol(strikeguardobj,i,j,tile-184);
					break;

				case 234:
				case 235:
				case 236:
				case 237:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 216:
				case 217:
				case 218:
				case 219:
					SpawnNetStand(overpatrolobj,i,j,tile-216,0);
					break;

				case 242:
				case 243:
				case 244:
				case 245:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 224:
				case 225:
				case 226:
				case 227:
					SpawnNetStand(overpatrolobj,i,j,tile-224,1);
					break;

				case 238:
				case 239:
				case 240:
				case 241:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 220:
				case 221:
				case 222:
				case 223:
					SpawnNetPatrol(overpatrolobj,i,j,tile-220);
					break;
				case 306:
				case 307:
				case 308:
				case 309:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 288:
				case 289:
				case 290:
				case 291:
					SpawnNetStand(triadenforcerobj,i,j,tile-288,0);
					break;

				case 314:
				case 315:
				case 316:
				case 317:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 296:
				case 297:
				case 298:
				case 299:
					SpawnNetStand(triadenforcerobj,i,j,tile-296,1);
					break;

				case 310:
				case 311:
				case 312:
				case 313:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 292:
				case 293:
				case 294:
				case 295:
					SpawnNetPatrol(triadenforcerobj,i,j,tile-292);
					break;

				case 342:
				case 343:
				case 344:
				case 345:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 324:
				case 325:
				case 326:
				case 327:
					SpawnNetStand(blitzguardobj,i,j,tile-324,0);
					break;

				case 350:
				case 351:
				case 352:
				case 353:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 332:
				case 333:
				case 334:
				case 335:
					SpawnNetStand(blitzguardobj,i,j,tile-332,1);
					break;

				case 346:
				case 347:
				case 348:
				case 349:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;
				case 328:
				case 329:
				case 330:
				case 331:
					SpawnNetPatrol(blitzguardobj,i,j,tile-328);
					break;

				case 378:
				case 379:
				case 380:
				case 381:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 360:
				case 361:
				case 362:
				case 363:
					SpawnNetStand(deathmonkobj,i,j,tile-360,0);
					break;

				case 386:
				case 387:
				case 388:
				case 389:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 368:
				case 369:
				case 370:
				case 371:
					SpawnNetStand(deathmonkobj,i,j,tile-368,1);
					break;

				case 382:
				case 383:
				case 384:
				case 385:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 364:
				case 365:
				case 366:
				case 367:
					SpawnNetPatrol(deathmonkobj,i,j,tile-364);
					break;

				case 414:
				case 415:
				case 416:
				case 417:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 396:
				case 397:
				case 398:
				case 399:
					SpawnNetStand(dfiremonkobj,i,j,tile-396,0);
					break;



				case 422:
				case 423:
				case 424:
				case 425:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;


				case 404:
				case 405:
				case 406:
				case 407:
					SpawnNetStand(dfiremonkobj,i,j,tile-404,1);
					break;

				case 418:
				case 419:
				case 420:
				case 421:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 400:
				case 401:
				case 402:
				case 403:
					SpawnNetPatrol(dfiremonkobj,i,j,tile-400);
					break;

				case 99:
					SpawnNetStand(b_darianobj,i,j,tile-99,0);
					break;
				case 100:
					SpawnNetStand(b_heinrichobj,i,j,tile-100,0);
					break;
				case 101:
					SpawnNetStand(b_darkmonkobj,i,j,tile-101,0);
					MISCVARS->TOMLOC.x = i;
					MISCVARS->TOMLOC.y = j;
					break;
				case 102:
					SpawnMultiSpriteActor(b_robobossobj,i,j,tile-102);
					break;

				case 103:
					SpawnSnake(i,j);
					break;

				case 426:
				case 427:
				case 428:
				case 429:
					if (gamestate.difficulty < gd_hard)
						break;
					tile -= 18;

				case 408:
				case 409:
				case 410:
				case 411:
					SpawnNetPatrol(wallopobj,i,j,tile-408);
					break;


			  }
			}
		 }
}


void SpawnNetStand (classtype which, int tilex, int tiley, int dir, int ambush)
{
	statetype *temp;

 #if (SHAREWARE == 1)
   switch(which)
      {
       case overpatrolobj:
       case wallopobj:
       case deathmonkobj:
       case dfiremonkobj:
       case b_darianobj:
       case b_heinrichobj:
       case b_darkmonkobj:
         Error("\n%s actor at %d,%d not allowed in shareware !",debugstr[which],tilex,tiley);
         break;
      default:
	  ;
      }
 #endif



 if ((temp = UPDATE_STATES[STAND][which-lowguardobj]) != NULL)
   {
   SpawnNewObj(tilex,tiley,temp,which);
   if (!loadedgame)
      gamestate.killtotal++;


   if (ambush)
      new->flags |= FL_AMBUSH;


   StandardEnemyInit(new,dir);

   if (which == b_darkmonkobj)
      {
      new->flags |= (FL_NOFRICTION);//|FL_INVULNERABLE);
      new->speed = ENEMYRUNSPEED*2;
      }


   if (MAPSPOT(tilex,tiley,2) == 0xdead)
      {
      new->flags |= FL_KEYACTOR;
      MISCVARS->KEYACTORSLEFT++;
      }

   PreCacheActor(which,0);
   }
 //else
   //Error("NULL initialization error");
}


void SpawnNetPatrol (classtype which, int tilex, int tiley, int dir)
{
	statetype *temp;
 int path=PATH;


 #if (SHAREWARE==1)
   switch(which)
      {
       case overpatrolobj:
       case wallopobj:
       case deathmonkobj:
       case dfiremonkobj:
       case b_darianobj:
       case b_heinrichobj:
       case b_darkmonkobj:
         Error("\n%s actor at %d,%d not allowed in shareware !",debugstr[which],tilex,tiley);
         break;
      default:
	  ;
      }

 #endif


 if ((temp= UPDATE_STATES[path][(int)(which-lowguardobj)]) != NULL)
   {
   SpawnNewObj(tilex,tiley,temp,which);

   if (!loadedgame)
      gamestate.killtotal++;


   StandardEnemyInit(new,dir);

   if ((which == wallopobj) || (which == roboguardobj))
      {new->flags |= FL_NOFRICTION;
      //new->flags &= ~FL_SHOOTABLE;
      new->dir <<= 1;
      ParseMomentum(new,dirangle16[new->dir]);
      }
   else
      ParseMomentum(new,dirangle8[new->dir]);


   if (MAPSPOT(tilex,tiley,2) == 0xdead)
      {new->flags |= FL_KEYACTOR;
      MISCVARS->KEYACTORSLEFT++;
      }

   PreCacheActor(which,0);
   }

}

