
/******************************************************************************\
* TCP_IP_Net.c - TCP/UDP client using Winsock 
\******************************************************************************/

/*

 Copyright  2004, Birger N. Andreasen 
 Please send any bugreports, comments and other issues to:
 E-Mail = bna@post10.tele.dk
 Homepage with other ROTT stuff = http://www.riseofthetriad.dk/

*/

#pragma warning (disable : 4996)//disable The POSIX name for this item is deprecated

#define WIN32_LEAN_AND_MEAN
#include <winsock2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
 
#include "rottnet.h"

#define DEFAULT_PORT 61000//5001
#define DEFAULT_PROTO SOCK_STREAM // TCP

extern void	WriteLBtext(LPSTR txt);
//Globals
extern rottcom_t   *rottcom;
extern int EmergencyExit;
int iG_portnb;
int EmergencyExit;

//client
WSADATA wsaData;
SOCKET  conn_socket;
int socket_type;
//	socket_type = SOCK_STREAM;//TCP
//	socket_type = SOCK_DGRAM;//UDP
struct sockaddr_in Tcpserver;
struct hostent *hp;
//server 
struct sockaddr_in local, from;
SOCKET listen_socket, msgsock;
fd_set readfds, writefds, exceptfd,exceptfds;

//LPDPLAYINFO			G_lpDPInfo;
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include "DPwinrott.h"
#include "resource.h"
/*
typedef struct {
	byte dwDestination;							// message type ()
	byte dwSender;								// message type ()
	__int16 dwDatalen;
	char szMsg[2048+128];	// message string (variable length)
} ROTT_DATASTRING, *LPROTT_DATASTRING;
*/
extern ROTT_DATASTRING		G_RottData;


int InitClientTCP_IP_socket (LPSTR SrvName, int portnb );
int InitServerTCP_IP_socket (LPSTR SrvName, int portnb );
int ReadTCPPacket (BOOL UseServerSocket );
int WriteTCPPacket (BOOL UseServerSocket );

//--------------------------------------------------------------------------------------
int InitClientTCP_IP_socket (LPSTR SrvName,int portnb )
{


	char			*server_name= "";
	unsigned short	port = DEFAULT_PORT;
	int				ioctl_opt =1;

	int				maxloop=-1;
	unsigned int	addr;
	char			buf[128];

	if (SrvName[0] != 0){
		server_name = SrvName;
	}

	//socket_type = SOCK_STREAM;//TCP
	socket_type = 	SOCK_DGRAM;//UDP

	if (WSAStartup(0x202,&wsaData) == SOCKET_ERROR) {
		sprintf(buf,"WSAStartup failed with error %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}
	
	port = portnb; 

	if (port == 0){
		WriteLBtext("Invalid port");
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	iG_portnb = port;
//
	// Attempt to detect if we should call gethostbyname() or
	// gethostbyaddr()

	if (isalpha(server_name[0])) {   /* server address is a name */
		hp = gethostbyname(server_name);
	}
	else  { /* Convert nnn.nnn address to a usable one */
		addr = inet_addr(server_name);
		hp = gethostbyaddr((char *)&addr,4,AF_INET);
	} 
	if (hp == NULL ) {
		sprintf(buf,"Client: Cannot resolve address [%s]: Error %d\n",
			server_name,WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	//
	// Copy the resolved information into the sockaddr_in structure
	//
	memset(&Tcpserver,0,sizeof(Tcpserver));
	memcpy(&(Tcpserver.sin_addr),hp->h_addr,hp->h_length);
	Tcpserver.sin_family = hp->h_addrtype;
	Tcpserver.sin_port = htons(port);

	conn_socket = socket(AF_INET,socket_type,0); /* Open a socket */
	if (conn_socket <0 ) {
		sprintf(buf,"Client: Error Opening socket: Error %d\n",
			WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}


	sprintf(buf,"Client connecting to: %s\n",hp->h_name);
	WriteLBtext(buf);

	if (connect(conn_socket,(struct sockaddr*)&Tcpserver,sizeof(Tcpserver))
		== SOCKET_ERROR) {
		sprintf(buf,"connect() failed: %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	//
	// Set the socket to non-blocking mode.
	//
	if (ioctlsocket(conn_socket,FIONBIO,&ioctl_opt) == SOCKET_ERROR) {
		sprintf(buf,"ioctlsocket failed %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}



	return 1;
}
//--------------------------------------------------------------------------------------
int InitServerTCP_IP_socket (LPSTR SrvName, int portnb )
{


	char *interfacex= NULL;
	unsigned short port=DEFAULT_PORT;
	int  ioctl_opt =1;
	char buf[128];


	//socket_type = SOCK_STREAM;//TCP
	socket_type = SOCK_DGRAM;//udp

	if (WSAStartup(0x202,&wsaData) == SOCKET_ERROR) {
		sprintf(buf,"WSAStartup failed with error %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	
	port = portnb; 
	if (port <= 0){
		WriteLBtext("Invalid port");
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	iG_portnb = port;

	local.sin_family = AF_INET;
	local.sin_addr.s_addr = (!interfacex)?INADDR_ANY:inet_addr(interfacex); 

	/* 
	 * Port MUST be in Network Byte Order
	 */
	local.sin_port = htons(port);

	listen_socket = socket(AF_INET, socket_type,0); // TCP socket
	
	if (listen_socket == INVALID_SOCKET){
		sprintf(buf,"socket() failed with error %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	//
	// bind() associates a local address and port combination with the
	// socket just created. This is most useful when the application is a 
	// server that has a well-known port that clients know about in advance.
	//
	if (bind(listen_socket,(struct sockaddr*)&local,sizeof(local) ) 
		== SOCKET_ERROR) {
		sprintf(buf,"bind() failed with error %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	//
	// Set the socket to non-blocking mode.
	//
	if (ioctlsocket(listen_socket,FIONBIO,&ioctl_opt) == SOCKET_ERROR) {
		sprintf(buf,"ioctlsocket failed %d\n",WSAGetLastError());
		WriteLBtext(buf);
		WSACleanup();
    	EmergencyExit = 1;
		return -1;
	}

	  
	msgsock = listen_socket;
	return 1;
}
//--------------------------------------------------------------------------------------

int ReadTCPPacket (BOOL UseServerSocket )
{
	int	  fromlen,rc;
	
	fromlen =sizeof(from);

	if (UseServerSocket == TRUE){
		rc = recvfrom(msgsock,(char*)&G_RottData,2048,0,(struct sockaddr *)&from,&fromlen);

   }else{
		rc = recv(conn_socket,(char*)&G_RottData,2048,0 );
		if (rc == SOCKET_ERROR) {
			return -1;
		}
		if (rc==0){
			G_RottData.dwDestination = -1;
			G_RottData.dwSender = -1;
			G_RottData.dwDatalen = -1;
			return -1;
		}
	}
	return 1;

}
//--------------------------------------------------------------------------------------

int WriteTCPPacket (BOOL UseServerSocket )
{
   
	int	  retval,fromlen;
	TIMEVAL timeval ;

	timeval.tv_sec=0;
	timeval.tv_usec=0;

	fromlen =sizeof(from);

	if (UseServerSocket == TRUE){
	  	retval = sendto(msgsock,(char*)&G_RottData, G_RottData.dwDatalen +4,0,
				(struct sockaddr *)&from,fromlen);
	}else{
		retval = send(conn_socket,(char*)&G_RottData, G_RottData.dwDatalen +4,0 );
   		if (retval == SOCKET_ERROR) {
			return 0;
		}
	}

	return 1;

}


